﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace N_Series_SDK
{
    public partial class CalWavelength : Form
    {
        public NSeries pParent;
        public int iSelDev;
        public double[] dGetWLTable;
        public short sSelChannel;

        public CalWavelength(NSeries hHwnd)
        {
            InitializeComponent();

            pParent = hHwnd;
            iSelDev = pParent.selDev;
            
            dGetWLTable = new double[pParent.m_stDeviceInfo[iSelDev].iRealPixel];
            sSelChannel = pParent.m_stDeviceInfo[iSelDev].sChannel;

            MemDataDisplay();

            cbSelWLTable.SelectedIndex = 0;
        }

        public void MemDataDisplay()
        {
            short sRtn;
            double[] dCoef = new double[30];
            short sOrder = 0;

            sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalCoeff_User(dCoef, ref sOrder, sSelChannel);
            if (sRtn != (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
            {
                dgvCurrentCoefficient.Rows.Clear();

                for (int i = 0; i < sOrder + 1; i++)
                    dgvCurrentCoefficient.Rows.Add(i.ToString(), dCoef[i].ToString());
            }
            else
                return;

            double[] dPixel = new double[30];
            double[] dWavelength = new double[30];
            short sPointNum = 0;

            sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalPoint_User(dPixel, dWavelength, ref sPointNum, sSelChannel);
            if (sRtn != (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
            {
                dgvCurrentCalPoint.Rows.Clear();

                for (int i = 0; i < sPointNum; i++)
                    dgvCurrentCalPoint.Rows.Add(dPixel[i].ToString(), dWavelength[i].ToString());
            }
            else
                return;

            if (cbSelWLTable.SelectedIndex == 0)
            {
                for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                    pParent.m_KSPLIB_NSeries.NPolyCalc(dCoef, sOrder, i + 1, ref dGetWLTable[i]);
            }
            else
            {
                short order = 0;
                double[] dTempCoef = new double[30];

                if (sPointNum == 2)
                    order = 1;
                else if (sPointNum == 3)
                    order = 2;
                else
                    order = 3;

                pParent.m_KSPLIB_NSeries.NPolyFit(dPixel, dWavelength, sPointNum, dTempCoef, order);
                for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                    pParent.m_KSPLIB_NSeries.NPolyCalc(dTempCoef, order, i + 1, ref dGetWLTable[i]);
            }

            dgvGetWLTable.Rows.Clear();

            for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                dgvGetWLTable.Rows.Add((i + 1).ToString(), dGetWLTable[i].ToString("#.####"));
        }

        // Coefficient Memory
        private void btnWriteMemCoeff_Click(object sender, EventArgs e)
        {
            double[] dCoef = new double[30];
            short sOrder = 0;
            short sRtn;

            for(int i = 0; i < dgvSetCoefficient.Rows.Count; i++)
            {
                double dTempCoef = 0;

                try
                {
                    dTempCoef = double.Parse((string)dgvSetCoefficient.Rows[i].Cells[1].Value);
                    int iTempOrder = int.Parse((string)dgvSetCoefficient.Rows[i].Cells[0].Value);
                }
                catch (Exception ex)
                {
                    break;
                }

                dCoef[i] = dTempCoef;
                sOrder = (short)i;

                if (sOrder  > 30)
                    break;
            }

            if (sOrder != 0)
            {
                sRtn = pParent.m_KSPLIB_NSeries.NWriteWLCalCoeff_User(dCoef, sOrder, sSelChannel);
                if (sRtn < 0)
                {
                    MessageBox.Show("Error Function : NWriteWLCalCoeff_User().\nError String : " + pParent.m_KSPLIB_NSeries.NGetErrorString(sRtn).ToString(), "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

                MemDataDisplay();
            }
        }

        private void btnReadMemCoeff_Click(object sender, EventArgs e)
        {
            short sRtn;
            double[] dCoef = new double[10];
            short sOrder = 0;

            sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalCoeff_User(dCoef, ref sOrder, sSelChannel);
            if (sRtn == (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
            {
                MessageBox.Show("Error Function : NReadWLCalCoeff_User().\nError String : Empty EEPROM.", "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                dgvSetCoefficient.Rows.Clear();
                return;
            }

            dgvSetCoefficient.Rows.Clear();

            for (int i = 0; i < sOrder + 1; i++)
                dgvSetCoefficient.Rows.Add(i.ToString(), dCoef[i].ToString());
        }
        //

        // Cal Point Memory
        private void btnWriteMemPoint_Click(object sender, EventArgs e)
        {
            double[] dWavelength = new double[30];
            double[] dPixel = new double[30];
            short sPointNum = 0;
            short sRtn;

            for (int i = 0; i < dgvSetCalPoint.Rows.Count; i++)
            {
                double dTempPixel = 0;
                double dTempWL = 0;

                try
                {
                    dTempPixel = double.Parse((string)dgvSetCalPoint.Rows[i].Cells[0].Value);
                    dTempWL = double.Parse((string)dgvSetCalPoint.Rows[i].Cells[1].Value);
                }
                catch (Exception ex)
                {
                    break;
                }

                dPixel[i] = dTempPixel;
                dWavelength[i] = dTempWL;

                sPointNum = (short)(i + 1);

                if (sPointNum >= 30)
                    break;
            }

            if (sPointNum != 0)
            {
                sRtn = pParent.m_KSPLIB_NSeries.NWriteWLCalPoint_User(dPixel, dWavelength, sPointNum, sSelChannel);
                if (sRtn < 0)
                {
                    MessageBox.Show("Error Function : NWriteWLCalPoint_User().\nError String : " + pParent.m_KSPLIB_NSeries.NGetErrorString(sRtn).ToString(), "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }

                MemDataDisplay();
            }
        }

        private void btnReadMemPoint_Click(object sender, EventArgs e)
        {
            short sRtn;
            double[] dPixel = new double[30];
            double[] dWavelength = new double[30];
            short sPointNum = 0;

            sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalPoint_User(dPixel, dWavelength, ref sPointNum, sSelChannel);
            if (sRtn == (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
            {
                MessageBox.Show("Error Function : NReadWLCalCoeff_User().\nError String : Empty EEPROM.", "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                dgvSetCalPoint.Rows.Clear();
                return;
            }

            dgvSetCalPoint.Rows.Clear();

            for (int i = 0; i < sPointNum; i++)
                dgvSetCalPoint.Rows.Add(dPixel[i].ToString(), dWavelength[i].ToString());
        }
        //

        private void cbSelWLTable_SelectedIndexChanged(object sender, EventArgs e)
        {
            short sRtn;

            if (cbSelWLTable.SelectedIndex == 0)
            {
                double[] dCoef = new double[10];
                short sOrder = 0;

                sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalCoeff_User(dCoef, ref sOrder, sSelChannel);
                if (sRtn == (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
                {
                    MessageBox.Show("Error Function : NReadWLCalCoeff_User().\nError String : Empty EEPROM.", "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dgvSetCoefficient.Rows.Clear();
                    return;
                }

                for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                    pParent.m_KSPLIB_NSeries.NPolyCalc(dCoef, sOrder, i + 1, ref dGetWLTable[i]);
            }
            else
            {
                double[] dPixel = new double[30];
                double[] dWavelength = new double[30];
                short sPointNum = 0;
                short order = 0;
                double[] dTempCoef = new double[30];

                sRtn = pParent.m_KSPLIB_NSeries.NReadWLCalPoint_User(dPixel, dWavelength, ref sPointNum, sSelChannel);
                if (sRtn == (short)KSPLIB_NSeries.emErrorCode.SP_ERROR_EEPROM_EMPTY)
                {
                    MessageBox.Show("Error Function : NReadWLCalCoeff_User().\nError String : Empty EEPROM.", "ERROR", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    dgvSetCalPoint.Rows.Clear();
                    return;
                }

                if (sPointNum == 2)
                    order = 1;
                else if (sPointNum == 3)
                    order = 2;
                else
                    order = 3;

                pParent.m_KSPLIB_NSeries.NPolyFit(dPixel, dWavelength, sPointNum, dTempCoef, order);
                for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                    pParent.m_KSPLIB_NSeries.NPolyCalc(dTempCoef, order, i + 1, ref dGetWLTable[i]);
            }

            dgvGetWLTable.Rows.Clear();

            for (int i = 0; i < pParent.m_stDeviceInfo[iSelDev].iRealPixel; i++)
                dgvGetWLTable.Rows.Add((i + 1).ToString(), dGetWLTable[i].ToString("#.####"));
        }

        private void btnWLTable_Click(object sender, EventArgs e)
        {
            if (dgvGetWLTable.Rows.Count > 0)
            {
                SaveFileDialog pFileDlg = new SaveFileDialog();
                pFileDlg.Filter = "csv Files(*.csv)|*.csv|All Files(*.*)|*.*";
                pFileDlg.FileName = "WLTable.csv";
                pFileDlg.Title = "Please specify the location to save";


                if (pFileDlg.ShowDialog() == DialogResult.OK)
                {
                    System.IO.FileStream filestream = new System.IO.FileStream(pFileDlg.FileName, System.IO.FileMode.Create, System.IO.FileAccess.Write);
                    StreamWriter streamwriter = new StreamWriter(filestream);
                    string streamTxt = "[Wavelength Table]\n\n";

                    streamTxt += "Pixel,Wavelength(nm)\n";
                    for (int i = 0; i < dgvGetWLTable.Rows.Count; i++)
                        streamTxt += dgvGetWLTable.Rows[i].Cells[0].Value.ToString() + "," + dgvGetWLTable.Rows[i].Cells[1].Value.ToString() + "\n";

                    streamwriter.WriteLine(streamTxt);

                    streamwriter.Close();
                }
            }
        }
    }
}
